/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.wsrr;

import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.base.wsrr.VWWSRRRegistryItem;
import filenet.ws.api.wsrr.WSWSRRWsdlDocument;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class VWWSRRBrowseTreeCellRenderer
extends DefaultTreeCellRenderer {
    private ImageIcon m_WSRRMainIcon = VWImageLoader.createImageIcon("wsrrMain.gif");
    private ImageIcon m_WSRRRegistryIcon = VWImageLoader.createImageIcon("wsrrRegistry.gif");
    private ImageIcon m_wsdlIcon = VWImageLoader.createImageIcon("wsrrWsdl.gif");
    private ImageIcon m_WSRRRegistryUnknownIcon = VWImageLoader.createImageIcon("wsrrRegistryUnknown.gif");
    private ImageIcon m_WSRRRegistryUnreachableIcon = VWImageLoader.createImageIcon("wsrrRegistryBad.gif");

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value != null) {
            Object nodeInfo = null;
            String text = null;
            if (value instanceof DefaultMutableTreeNode) {
                nodeInfo = ((DefaultMutableTreeNode)value).getUserObject();
            }
            if (nodeInfo != null) {
                if (nodeInfo instanceof VWWSRRRegistryItem[]) {
                    this.setIcon(this.m_WSRRMainIcon);
                    text = VWResource.s_wsrrRegistryAndRepository;
                    this.setToolTipText(text);
                }
                if (nodeInfo instanceof VWWSRRRegistryItem) {
                    int registryState = ((VWWSRRRegistryItem)nodeInfo).getState();
                    if (registryState == 1) {
                        this.setIcon(this.m_WSRRRegistryIcon);
                        this.setToolTipText(VWResource.s_wsrrRegistryStateConnected);
                    } else if (registryState == 2) {
                        this.setIcon(this.m_WSRRRegistryUnreachableIcon);
                        this.setToolTipText(VWResource.s_wsrrRegistryStateUnreachable);
                    } else {
                        this.setIcon(this.m_WSRRRegistryUnknownIcon);
                        this.setToolTipText(VWResource.s_wsrrRegistryStateUnknown);
                    }
                    text = ((VWWSRRRegistryItem)nodeInfo).toString();
                } else if (nodeInfo instanceof WSWSRRWsdlDocument) {
                    String version = ((WSWSRRWsdlDocument)nodeInfo).getVersion();
                    text = version != null && version.trim().length() != 0 ? ((WSWSRRWsdlDocument)nodeInfo).toString() + " (" + version + ")" : ((WSWSRRWsdlDocument)nodeInfo).toString();
                    this.setIcon(this.m_wsdlIcon);
                    this.setToolTipText(text);
                }
                this.setText(text);
            }
            this.getAccessibleContext().setAccessibleDescription(text);
            this.getAccessibleContext().setAccessibleName(text);
            return this;
        }
        return comp;
    }
}

